program newton
  double precision :: valeur = 50.d0
  double precision :: tolerance
  double precision :: racine, x

  tolerance = 1.0d-1
  x = racine( valeur, tolerance )
  print '("Racine de ",f5.1," = ", d16.8)', valeur, x
  tolerance = 1.0d-6
  x = racine( valeur, tolerance )
  print '("Racine de ",f5.1," = ", d16.8)', valeur, x
end program newton

function racine( valeur, tol )
  double precision :: valeur, tol
  double precision :: racine
  double precision :: x = 1.0d0
! double precision :: x
  double precision :: x_prev
  integer          :: nb_iterations
 
  nb_iterations = 0
! x = 1.d0
  do
    nb_iterations = nb_iterations + 1
    x_prev = x
    x = 0.5 * (x_prev + valeur/x_prev)
    if ( abs(x-x_prev)/x < tol ) exit
  end do
  print *,"Nombre d'itrations = ", nb_iterations
  racine = x
end function racine
